/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.apply;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.srg2source.apply.RangeApplier;
import net.minecraftforge.srg2source.range.RangeMap;
import net.minecraftforge.srg2source.range.entries.MetaEntry;
import net.minecraftforge.srg2source.range.entries.MixinAccessorMeta;

public class ClassMeta {
    private final RangeApplier applier;
    private final Map<String, Map<String, MixinAccessorMeta>> accessors = new HashMap<String, Map<String, MixinAccessorMeta>>();

    public static ClassMeta create(RangeApplier applier, Map<String, RangeMap> ranges) {
        ClassMeta ret = new ClassMeta(applier);
        for (RangeMap range : ranges.values()) {
            for (MetaEntry entry : range.getMeta()) {
                switch (entry.getType()) {
                    case MIXIN_ACCESSOR: {
                        MixinAccessorMeta acc = (MixinAccessorMeta)entry;
                        ret.accessors.computeIfAbsent(acc.getOwner().getOwner(), k -> new HashMap()).put(acc.getOwner().getName() + acc.getOwner().getDesc(), acc);
                        break;
                    }
                }
            }
        }
        return ret;
    }

    private ClassMeta(RangeApplier applier) {
        this.applier = applier;
    }

    public String mapMethod(String owner, String name, String desc) {
        Map<String, MixinAccessorMeta> tmp = this.accessors.get(owner);
        if (tmp == null) {
            return name;
        }
        MixinAccessorMeta acc = tmp.get(name + desc);
        if (acc == null) {
            return name;
        }
        String tName = acc.getTarget().getName();
        if (acc.getTarget().getDesc().indexOf(40) == -1) {
            String renamed = this.applier.mapField(acc.getTarget().getOwner(), tName);
            if (renamed != name) {
                return acc.getPrefix() + renamed.substring(0, 1).toUpperCase(Locale.ROOT) + renamed.substring(1);
            }
        } else if ("<init>".equals(tName)) {
            String renamed = this.applier.mapClass(acc.getTarget().getOwner());
            if (renamed != acc.getTarget().getOwner()) {
                int idx = renamed.lastIndexOf(36);
                if (idx != -1) {
                    renamed = renamed.substring(idx + 1);
                }
                if ((idx = renamed.lastIndexOf(47)) != -1) {
                    renamed = renamed.substring(idx + 1);
                }
                return acc.getPrefix() + renamed.substring(0, 1).toUpperCase(Locale.ROOT) + renamed.substring(1);
            }
        } else {
            String renamed = this.applier.mapMethod(acc.getTarget().getOwner(), tName, acc.getTarget().getDesc());
            if (renamed != name) {
                return acc.getPrefix() + renamed.substring(0, 1).toUpperCase(Locale.ROOT) + renamed.substring(1);
            }
        }
        return name;
    }
}

