/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.srg2source.api.InputSupplier;
import net.minecraftforge.srg2source.api.SourceVersion;
import net.minecraftforge.srg2source.extract.RangeExtractor;
import net.minecraftforge.srg2source.util.io.ChainedInputSupplier;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import org.jetbrains.annotations.Nullable;

public class RangeExtractorBuilder {
    private SourceVersion sourceVersion = SourceVersion.JAVA_1_8;
    private PrintStream logStd = System.out;
    private PrintStream logErr = System.err;
    private PrintWriter output = null;
    private boolean batch = true;
    private List<File> libraries = new ArrayList<File>();
    private List<InputSupplier> inputs = new ArrayList<InputSupplier>();
    private File cache = null;
    private boolean enableMixins = false;
    private boolean fatalMixins = false;
    private boolean logWarnings = false;
    private boolean enablePreview = false;
    private boolean failOnError = false;

    public RangeExtractorBuilder sourceCompatibility(SourceVersion value) {
        this.sourceVersion = value;
        return this;
    }

    public RangeExtractorBuilder logger(File value) {
        try {
            return this.logger(new PrintStream(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RangeExtractorBuilder logger(Path value) {
        try {
            return this.logger(new PrintStream(Files.newOutputStream(value, new OpenOption[0])));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RangeExtractorBuilder logger(PrintStream value) {
        this.logStd = value;
        return this;
    }

    public RangeExtractorBuilder errorLogger(PrintStream value) {
        this.logErr = value;
        return this;
    }

    public RangeExtractorBuilder output(File value) {
        return this.output(value, StandardCharsets.UTF_8);
    }

    public RangeExtractorBuilder output(File value, Charset encoding) {
        try {
            if (!value.exists()) {
                File parent = value.getCanonicalFile().getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                value.createNewFile();
            }
            return this.output(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(value), encoding))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RangeExtractorBuilder output(Path value) {
        return this.output(value, StandardCharsets.UTF_8);
    }

    public RangeExtractorBuilder output(Path value, Charset encoding) {
        try {
            if (!Files.exists(value, new LinkOption[0])) {
                Path parent = value.toAbsolutePath().getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.createFile(value, new FileAttribute[0]);
            }
            return this.output(new PrintWriter(Files.newBufferedWriter(value, encoding, new OpenOption[0])));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RangeExtractorBuilder output(PrintWriter value) {
        if (this.output != null) {
            this.output.close();
        }
        this.output = value;
        return this;
    }

    public RangeExtractorBuilder batch() {
        return this.batch(true);
    }

    public RangeExtractorBuilder batch(boolean value) {
        this.batch = value;
        return this;
    }

    public RangeExtractorBuilder library(File value) {
        this.libraries.add(value);
        return this;
    }

    public RangeExtractorBuilder input(Path value) {
        return this.input(value, StandardCharsets.UTF_8);
    }

    public RangeExtractorBuilder input(Path value, @Nullable Charset encoding) {
        block7: {
            if (value == null || !Files.exists(value, new LinkOption[0])) {
                throw new IllegalArgumentException("Invalid input value: " + String.valueOf(value));
            }
            String filename = value.getFileName().toString().toLowerCase(Locale.ENGLISH);
            try {
                if (Files.isDirectory(value, new LinkOption[0])) {
                    this.inputs.add(FolderSupplier.create(value, encoding));
                    break block7;
                }
                if (filename.endsWith(".jar") || filename.endsWith(".zip")) {
                    try {
                        this.inputs.add(ZipInputSupplier.create(value, encoding));
                        break block7;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new IllegalArgumentException("Invalid input value: " + String.valueOf(value));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid input: " + String.valueOf(value), e);
            }
        }
        return this;
    }

    public RangeExtractorBuilder input(InputSupplier value) {
        this.inputs.add(value);
        return this;
    }

    public RangeExtractorBuilder cache(File value) {
        this.cache = value;
        return this;
    }

    public RangeExtractorBuilder enableMixins() {
        this.enableMixins = true;
        return this;
    }

    public RangeExtractorBuilder fatalMixins() {
        this.fatalMixins = true;
        return this;
    }

    public RangeExtractorBuilder logWarnings() {
        this.logWarnings = true;
        return this;
    }

    public RangeExtractorBuilder enablePreview() {
        this.enablePreview = true;
        return this;
    }

    public RangeExtractorBuilder failOnError() {
        this.failOnError = true;
        return this;
    }

    public RangeExtractor build() {
        RangeExtractor ret = new RangeExtractor();
        ret.setLogger(this.logStd);
        ret.setErrorLogger(this.logErr);
        if (this.output != null) {
            ret.setOutput(this.output);
        }
        ret.setSourceCompatibility(this.sourceVersion);
        ret.setBatchASTs(this.batch);
        this.libraries.forEach(ret::addLibrary);
        if (this.inputs.size() == 1) {
            ret.setInput(this.inputs.get(0));
        } else {
            ret.setInput(new ChainedInputSupplier(this.inputs));
        }
        if (this.enableMixins) {
            ret.enableMixins();
        }
        if (this.fatalMixins) {
            ret.fatalMixins();
        }
        if (this.logWarnings) {
            ret.logWarnings();
        }
        if (this.enablePreview) {
            ret.enablePreview();
        }
        if (this.failOnError) {
            ret.failOnError();
        }
        if (this.cache != null) {
            try (FileInputStream fin = new FileInputStream(this.cache);){
                ret.loadCache(fin);
            }
            catch (IOException e) {
                System.out.println("Error Loading Caching: " + String.valueOf(this.cache));
                e.printStackTrace();
            }
        }
        return ret;
    }
}

