/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraftforge.srg2source.api.RangeExtractorBuilder;
import net.minecraftforge.srg2source.api.SourceVersion;

public class RangeExtractMain {
    private static final ValueConverter<Path> PATH_CONVERTER = new PathConverter(new PathProperties[0]);

    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec libArg = parser.acceptsAll(Arrays.asList("e", "lib")).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec inputArg = parser.acceptsAll(Arrays.asList("in", "input")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec outputArg = parser.acceptsAll(Arrays.asList("out", "output")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec batch = parser.accepts("batch").withOptionalArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec mixins = parser.accepts("mixins").withOptionalArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec mixins_fatal = parser.accepts("fatalmixins").withOptionalArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec jversionArg = parser.acceptsAll(Arrays.asList("sc", "source-compatibility")).withRequiredArg().ofType(SourceVersion.class).defaultsTo((Object)SourceVersion.JAVA_1_8, (Object[])new SourceVersion[0]).withValuesConvertedBy((ValueConverter)new ValueConverter<SourceVersion>(){

            public SourceVersion convert(String value) {
                return SourceVersion.parse(value);
            }

            public Class<? extends SourceVersion> valueType() {
                return SourceVersion.class;
            }

            public String valuePattern() {
                ArrayList<String> ret = new ArrayList<String>();
                for (SourceVersion v : SourceVersion.values()) {
                    ret.add(v.name());
                    ret.add(v.getSpec());
                }
                return ret.stream().collect(Collectors.joining(","));
            }
        });
        try {
            OptionSet options = parser.parse(args);
            boolean enableMixins = options.has((OptionSpec)mixins) && (Boolean)options.valueOf((OptionSpec)mixins) != false;
            boolean fatalMixins = enableMixins && options.has((OptionSpec)mixins_fatal) && (Boolean)options.valueOf((OptionSpec)mixins_fatal) != false;
            System.out.println("Compat: " + String.valueOf(options.valueOf((OptionSpec)jversionArg)));
            System.out.println("Output: " + String.valueOf(options.valueOf((OptionSpec)outputArg)));
            System.out.println("Batch:  " + String.valueOf(options.valueOf((OptionSpec)batch)));
            System.out.println("Mixins: " + enableMixins);
            System.out.println("Fatal:  " + fatalMixins);
            RangeExtractorBuilder builder = new RangeExtractorBuilder().sourceCompatibility((SourceVersion)((Object)options.valueOf((OptionSpec)jversionArg))).output((Path)options.valueOf((OptionSpec)outputArg)).batch((Boolean)options.valueOf((OptionSpec)batch));
            if (options.has((OptionSpec)libArg)) {
                options.valuesOf((OptionSpec)libArg).forEach(v -> {
                    System.out.println("Lib:    " + String.valueOf(v));
                    builder.library((File)v);
                });
            }
            options.valuesOf((OptionSpec)inputArg).forEach(v -> {
                System.out.println("Input:  " + String.valueOf(v));
                builder.input((Path)v);
            });
            if (enableMixins) {
                builder.enableMixins();
            }
            if (fatalMixins) {
                builder.fatalMixins();
            }
            builder.build().run();
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }
}

