/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraftforge.srg2source.api.RangeApplierBuilder;

public class RangeApplyMain {
    private static final ValueConverter<Path> PATH_CONVERTER = new PathConverter(new PathProperties[0]);

    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpArg = parser.acceptsAll(RangeApplyMain.a("h", "help")).forHelp();
        ArgumentAcceptingOptionSpec inputArg = parser.acceptsAll(RangeApplyMain.a("in", "input", "srcRoot")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec outArg = parser.acceptsAll(RangeApplyMain.a("out", "output", "outDir")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec excArg = parser.acceptsAll(RangeApplyMain.a("exc", "excFiles")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER);
        ArgumentAcceptingOptionSpec mappingArg = parser.acceptsAll(RangeApplyMain.a("map", "srg", "srgFiles")).withRequiredArg().withValuesConvertedBy(PATH_CONVERTER).required();
        ArgumentAcceptingOptionSpec rangeArg = parser.acceptsAll(RangeApplyMain.a("rm", "range", "srcRangeMap")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec importArg = parser.acceptsAll(RangeApplyMain.a("keepImports")).withOptionalArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        OptionSpecBuilder sortImportArg = parser.acceptsAll(RangeApplyMain.a("sortImports"));
        OptionSpecBuilder guessLambdasArg = parser.acceptsAll(RangeApplyMain.a("guessLambdas"));
        OptionSpecBuilder guessLocalsArg = parser.acceptsAll(RangeApplyMain.a("guessLocals"));
        try {
            OptionSet options = parser.parse(args);
            if (options.has((OptionSpec)helpArg)) {
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            File range = (File)options.valueOf((OptionSpec)rangeArg);
            Path output = (Path)options.valueOf((OptionSpec)outArg);
            boolean keepImports = options.has((OptionSpec)importArg) && (Boolean)options.valueOf((OptionSpec)importArg) != false;
            System.out.println("Range:   " + String.valueOf(range));
            System.out.println("Output:  " + String.valueOf(output));
            System.out.println("Imports: " + keepImports);
            System.out.println("Sort:    " + options.has((OptionSpec)sortImportArg));
            System.out.println("Lambdas: " + options.has((OptionSpec)guessLambdasArg));
            System.out.println("Locals:  " + options.has((OptionSpec)guessLocalsArg));
            RangeApplierBuilder builder = new RangeApplierBuilder().range(range).output(output).guessLambdas(options.has((OptionSpec)guessLambdasArg)).guessLocals(options.has((OptionSpec)guessLocalsArg)).sortImports(options.has((OptionSpec)sortImportArg));
            if (options.has((OptionSpec)mappingArg)) {
                options.valuesOf((OptionSpec)mappingArg).forEach(v -> {
                    System.out.println("Map:     " + String.valueOf(v));
                    builder.srg((Path)v);
                });
            }
            options.valuesOf((OptionSpec)inputArg).forEach(v -> {
                System.out.println("Input:   " + String.valueOf(v));
                builder.input((Path)v);
            });
            if (options.has((OptionSpec)excArg)) {
                options.valuesOf((OptionSpec)excArg).forEach(v -> {
                    System.out.println("Exc:     " + String.valueOf(v));
                    builder.exc((Path)v);
                });
            }
            if (keepImports) {
                builder.keepImports();
            } else {
                builder.trimImports();
            }
            builder.build().run();
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private static List<String> a(String ... values) {
        return Arrays.asList(values);
    }
}

