/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source;

import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraftforge.srg2source.RangeApplyMain;
import net.minecraftforge.srg2source.RangeExtractMain;
import net.minecraftforge.srg2source.extract.RangeExtractor;
import net.minecraftforge.srg2source.util.TransformingUtil;

public class ConsoleTool {
    public static void main(String[] args) throws Exception {
        System.setProperty("osgi.nls.warnings", "ignore");
        if (RangeExtractor.hasBeenASMPatched()) {
            Redefined.main(args);
        } else {
            ClassLoader tcl = TransformingUtil.createTransformer();
            Class<?> cls = Class.forName(ConsoleTool.class.getName() + "$Redefined", true, tcl);
            cls.getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
        }
    }

    public static class Redefined {
        public static void main(String[] args) throws Exception {
            String arg;
            Task target = null;
            HashMap<CallSite, Task> tasks = new HashMap<CallSite, Task>();
            for (Task t : Task.values()) {
                tasks.put((CallSite)((Object)("--" + t.name().toLowerCase(Locale.ENGLISH))), t);
            }
            LinkedList<String> que = new LinkedList<String>();
            for (String arg2 : args) {
                que.add(arg2);
            }
            ArrayList<String> _args = new ArrayList<String>();
            while ((arg = (String)que.poll()) != null) {
                if (tasks.containsKey(arg.toLowerCase(Locale.ENGLISH))) {
                    if (target != null) {
                        throw new IllegalArgumentException("Only one task allowed at a time, trued to run " + arg + " when " + String.valueOf(target) + " already set");
                    }
                    target = (Task)((Object)tasks.get(arg.toLowerCase(Locale.ENGLISH)));
                    continue;
                }
                if ("--cfg".equals(arg)) {
                    String cfg = (String)que.poll();
                    if (cfg == null) {
                        throw new IllegalArgumentException("Invalid --cfg entry, missing file path");
                    }
                    Files.readAllLines(Paths.get(cfg, new String[0])).forEach(que::add);
                    continue;
                }
                if (arg.startsWith("--cfg=")) {
                    Files.readAllLines(Paths.get(arg.substring(6), new String[0])).forEach(que::add);
                    continue;
                }
                _args.add(arg);
            }
            if (target == null) {
                System.out.println("Must specify a task to run: " + tasks.keySet().stream().collect(Collectors.joining(", ")));
            } else {
                target.task.accept(_args.toArray(new String[_args.size()]));
            }
        }
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void accept(T var1) throws Exception;
    }

    private static enum Task {
        APPLY(RangeApplyMain::main),
        EXTRACT(RangeExtractMain::main);

        private Consumer<String[]> task;

        private Task(Consumer<String[]> task) {
            this.task = task;
        }
    }
}

