/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.selection;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.MetadataIOHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JarSelector<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarSelector.class);
    public static final String CONTAINED_JARS_METADATA_PATH = "META-INF/jarjar/metadata.json";
    private final Set<T> seen = new HashSet<T>();
    private final Set<DetectionResult<T>> detected = new HashSet<DetectionResult<T>>();
    private final Map<String, T> claimed = new HashMap<String, T>();
    private final Set<ContainedJarIdentifier> identifiers = new HashSet<ContainedJarIdentifier>();

    protected JarSelector() {
    }

    @Deprecated
    public static <T, E extends Throwable> List<T> detectAndSelect(List<T> source, final BiFunction<T, Path, Optional<InputStream>> resourceReader, final BiFunction<T, Path, Optional<T>> sourceProducer, final Function<T, String> identificationProducer, final Function<Collection<ResolutionFailureInformation<T>>, E> failureExceptionProducer) throws E {
        JarSelector selector = new JarSelector<T>(){

            @Override
            @Nullable
            protected InputStream getResource(T source, String path) {
                return ((Optional)resourceReader.apply(source, Paths.get(path, new String[0]))).orElse(null);
            }

            @Override
            @Nullable
            protected T getNested(T source, String path) {
                return ((Optional)sourceProducer.apply(source, Paths.get(path, new String[0]))).orElse(null);
            }

            @Override
            protected String getIdentifier(T source) {
                return (String)identificationProducer.apply(source);
            }

            @Override
            protected Throwable getFailureException(Collection<ResolutionFailureInformation<T>> failures) {
                return (Throwable)failureExceptionProducer.apply(failures);
            }
        };
        selector.force((Collection<T>)source);
        return selector.select();
    }

    public boolean isRequired(String group, String artifact) {
        return this.isRequired(new ContainedJarIdentifier(group, artifact));
    }

    public boolean isRequired(ContainedJarIdentifier identifier) {
        return this.identifiers.contains(identifier);
    }

    protected abstract InputStream getResource(T var1, String var2);

    protected abstract T getNested(T var1, String var2);

    protected abstract String getIdentifier(T var1);

    protected abstract Throwable getFailureException(Collection<ResolutionFailureInformation<T>> var1);

    public void force(T source) {
        String id = this.getIdentifier(source);
        T old = this.claimed.putIfAbsent(id, source);
        if (old != null) {
            LOGGER.warn("Attempted to force two jars which have the same identification {}: {} and {}. Using {}", new Object[]{id, old, source, old});
        }
        this.add(source);
    }

    public void force(Collection<T> sources) {
        for (T source : sources) {
            String id = this.getIdentifier(source);
            T old = this.claimed.putIfAbsent(id, source);
            if (old == null) continue;
            LOGGER.warn("Attempted to force two jars which have the same identification {}: {} and {}. Using {}", new Object[]{id, old, source, old});
        }
        this.add(sources);
    }

    public void option(T source, ContainedJarMetadata meta) {
        this.detected.add(new DetectionResult(meta, source, 0));
    }

    public void addRequirement(ContainedJarMetadata meta) {
        this.detected.add(new DetectionResult(meta, null, 0));
    }

    public void add(T source) {
        this.add((Collection<T>)Collections.singletonList(source));
    }

    public void add(Collection<T> source) {
        HashMap depths = new HashMap();
        ArrayDeque<T> queue = new ArrayDeque<T>(source);
        while (!queue.isEmpty()) {
            Object current = queue.remove();
            if (!this.seen.add(current)) continue;
            Metadata metadata = null;
            try {
                InputStream is = this.getResource(current, CONTAINED_JARS_METADATA_PATH);
                Object object = null;
                try {
                    if (is == null) continue;
                    metadata = MetadataIOHandler.fromStream((InputStream)is).orElse(null);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is == null) continue;
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    is.close();
                    continue;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to parse metadata", (Throwable)e);
            }
            if (metadata == null) continue;
            byte depth = (byte)(depths.getOrDefault(current, (byte)0) + 1);
            if (depth < 1) {
                depth = 127;
            }
            for (ContainedJarMetadata jar : metadata.jars()) {
                Object nested = jar.path() == null || jar.path().isEmpty() ? null : (Object)this.getNested(current, jar.path());
                DetectionResult detection = new DetectionResult(jar, nested, depth);
                this.detected.add(detection);
                this.identifiers.add(jar.identifier());
                if (nested == null) continue;
                queue.add(nested);
                depths.put(nested, depth);
            }
        }
    }

    public List<T> select() {
        HashMap<ContainedJarMetadata, Collection> detectedJarsBySource = new HashMap<ContainedJarMetadata, Collection>();
        HashMap<ContainedJarIdentifier, Collection> metadataByIdentifier = new HashMap<ContainedJarIdentifier, Collection>();
        HashMap<ContainedJarIdentifier, Collection> extraRestrictions = new HashMap<ContainedJarIdentifier, Collection>();
        for (DetectionResult<T> detection : this.detected) {
            detectedJarsBySource.computeIfAbsent(((DetectionResult)detection).metadata, k -> new HashSet()).add(detection);
            Collection candidates = metadataByIdentifier.computeIfAbsent(((DetectionResult)detection).metadata.identifier(), k -> new HashSet());
            if (((DetectionResult)detection).source() == null) {
                extraRestrictions.computeIfAbsent(((DetectionResult)detection).metadata.identifier(), k -> new HashSet()).add(((DetectionResult)detection).metadata);
                continue;
            }
            candidates.add(((DetectionResult)detection).metadata);
        }
        HashSet<SelectionResult> options = new HashSet<SelectionResult>();
        boolean failed = false;
        for (Map.Entry entry : metadataByIdentifier.entrySet()) {
            ContainedJarMetadata jar;
            ContainedJarMetadata found;
            Object jar22;
            ContainedJarIdentifier identifier = (ContainedJarIdentifier)entry.getKey();
            Collection jars = (Collection)entry.getValue();
            Object range = null;
            for (ContainedJarMetadata jar22 : jars) {
                range = JarSelector.restrictRanges(range, jar22.version().range());
            }
            for (Object jar22 : (Collection)extraRestrictions.getOrDefault(identifier, Collections.emptyList())) {
                range = JarSelector.restrictRanges((VersionRange)range, jar22.version().range());
            }
            if (jars.isEmpty()) {
                options.add(new SelectionResult(identifier, Optional.empty(), false));
                failed = true;
                continue;
            }
            if (range == null || !JarSelector.isValid((VersionRange)range)) {
                options.add(new SelectionResult(identifier, Optional.empty(), true));
                failed = true;
                continue;
            }
            if (jars.size() == 1) {
                ContainedJarMetadata jar3 = (ContainedJarMetadata)jars.iterator().next();
                if (range.containsVersion(jar3.version().artifactVersion())) {
                    options.add(new SelectionResult(identifier, Optional.of(jar3), false));
                    continue;
                }
                options.add(new SelectionResult(identifier, Optional.empty(), false));
                failed = true;
                continue;
            }
            if (range.getRecommendedVersion() != null) {
                found = null;
                jar22 = jars.iterator();
                while (jar22.hasNext()) {
                    jar = (ContainedJarMetadata)jar22.next();
                    if (!jar.version().artifactVersion().equals(range.getRecommendedVersion())) continue;
                    found = jar;
                    break;
                }
                if (found != null) {
                    options.add(new SelectionResult(identifier, Optional.of(found), false));
                    continue;
                }
            }
            found = null;
            jar22 = jars.iterator();
            while (jar22.hasNext()) {
                jar = (ContainedJarMetadata)jar22.next();
                if (!range.containsVersion(jar.version().artifactVersion()) || found != null && jar.version().artifactVersion().compareTo((Object)found.version().artifactVersion()) <= 0) continue;
                found = jar;
            }
            if (found == null) {
                failed = true;
            }
            options.add(new SelectionResult(identifier, Optional.ofNullable(found), false));
        }
        if (failed) {
            ArrayList<ResolutionFailureInformation<T>> failures = new ArrayList<ResolutionFailureInformation<T>>();
            for (SelectionResult result : options) {
                if (result.selected().isPresent()) continue;
                HashSet sources = new HashSet();
                for (ContainedJarMetadata jar3 : (Collection)metadataByIdentifier.get(result.identifier())) {
                    sources.add(new SourceWithRequestedVersionRange(((Collection)detectedJarsBySource.get(jar3)).stream().map(rec$ -> ((DetectionResult)rec$).source()).filter(s -> s != null).collect(Collectors.toSet()), jar3.version().range(), jar3.version().artifactVersion()));
                }
                failures.add(new ResolutionFailureInformation(JarSelector.getFailureReason(result), result.identifier(), sources));
            }
            LOGGER.error("Failed to select jars for {}", failures);
            return (List)JarSelector.sneak(this.getFailureException(failures));
        }
        ArrayList<Object> selectedJars = new ArrayList<Object>(options.size());
        for (SelectionResult result : options) {
            Collection sourceOfJar;
            ContainedJarMetadata meta = result.selected().orElse(null);
            if (meta == null || (sourceOfJar = (Collection)detectedJarsBySource.get(meta)) == null || sourceOfJar.isEmpty()) continue;
            DetectionResult nearest = null;
            for (DetectionResult info : sourceOfJar) {
                if (nearest != null && nearest.depth <= info.depth) continue;
                nearest = info;
            }
            Object winner = nearest == null ? null : nearest.source;
            if (winner == null) continue;
            selectedJars.add(winner);
        }
        HashMap hashMap = new HashMap();
        Iterator itr = selectedJars.iterator();
        while (itr.hasNext()) {
            Object jar = itr.next();
            String id = this.getIdentifier(jar);
            Object old = this.claimed.get(id);
            if (old != null) {
                if (old != jar) {
                    LOGGER.warn("Attempted to select a dependency jar for JarJar which was passed in as source: {}. Using {}", (Object)id, old);
                }
                itr.remove();
                continue;
            }
            old = hashMap.putIfAbsent(id, jar);
            if (old == null) continue;
            LOGGER.warn("Attempted to select two dependency jars from JarJar which have the same identification {}: {} and {}. Using the former", new Object[]{id, old, jar});
            itr.remove();
        }
        return selectedJars;
    }

    private static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    private static VersionRange restrictRanges(VersionRange versionRange, VersionRange versionRange2) {
        if (versionRange == null) {
            return versionRange2;
        }
        if (versionRange2 == null) {
            return versionRange;
        }
        return versionRange.restrict(versionRange2);
    }

    private static boolean isValid(VersionRange range) {
        return range.getRecommendedVersion() == null && range.hasRestrictions();
    }

    private static FailureReason getFailureReason(SelectionResult selectionResult) {
        if (selectionResult.selected().isPresent()) {
            throw new IllegalArgumentException("Resolution succeeded, not failure possible");
        }
        if (selectionResult.noValidRangeFound()) {
            return FailureReason.VERSION_RESOLUTION_FAILED;
        }
        return FailureReason.NO_MATCHING_JAR;
    }

    public static final class ResolutionFailureInformation<Z> {
        private final FailureReason failureReason;
        private final ContainedJarIdentifier identifier;
        private final Collection<SourceWithRequestedVersionRange<Z>> sources;

        public ResolutionFailureInformation(FailureReason failureReason, ContainedJarIdentifier identifier, Collection<SourceWithRequestedVersionRange<Z>> sources) {
            this.failureReason = failureReason;
            this.identifier = identifier;
            this.sources = sources;
        }

        public FailureReason failureReason() {
            return this.failureReason;
        }

        public ContainedJarIdentifier identifier() {
            return this.identifier;
        }

        public Collection<SourceWithRequestedVersionRange<Z>> sources() {
            return this.sources;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResolutionFailureInformation)) {
                return false;
            }
            ResolutionFailureInformation that = (ResolutionFailureInformation)o;
            if (this.failureReason != that.failureReason) {
                return false;
            }
            if (!this.identifier.equals((Object)that.identifier)) {
                return false;
            }
            return this.sources.equals(that.sources);
        }

        public int hashCode() {
            int result = this.failureReason.hashCode();
            result = 31 * result + this.identifier.hashCode();
            result = 31 * result + this.sources.hashCode();
            return result;
        }

        public String toString() {
            return "ResolutionFailureInformation{failureReason=" + (Object)((Object)this.failureReason) + ", identifier=" + this.identifier + ", sources=" + this.sources + '}';
        }
    }

    public static final class SourceWithRequestedVersionRange<Z> {
        private final Collection<Z> sources;
        private final VersionRange requestedVersionRange;
        private final ArtifactVersion includedVersion;

        public SourceWithRequestedVersionRange(Collection<Z> sources, VersionRange requestedVersionRange, ArtifactVersion includedVersion) {
            this.sources = sources;
            this.includedVersion = includedVersion;
            this.requestedVersionRange = requestedVersionRange == null ? VersionRange.createFromVersion((String)includedVersion.toString()) : requestedVersionRange;
        }

        public Collection<Z> sources() {
            return this.sources;
        }

        public VersionRange requestedVersionRange() {
            return this.requestedVersionRange;
        }

        public ArtifactVersion includedVersion() {
            return this.includedVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceWithRequestedVersionRange)) {
                return false;
            }
            SourceWithRequestedVersionRange that = (SourceWithRequestedVersionRange)o;
            if (!this.sources.equals(that.sources)) {
                return false;
            }
            if (!this.requestedVersionRange.equals((Object)that.requestedVersionRange)) {
                return false;
            }
            return this.includedVersion.equals(that.includedVersion);
        }

        public int hashCode() {
            int result = this.sources.hashCode();
            result = 31 * result + this.requestedVersionRange.hashCode();
            result = 31 * result + this.includedVersion.hashCode();
            return result;
        }

        public String toString() {
            return "SourceWithRequestedVersionRange{source=" + this.sources + ", requestedVersionRange=" + this.requestedVersionRange + ", includedVersion=" + this.includedVersion + '}';
        }
    }

    public static enum FailureReason {
        VERSION_RESOLUTION_FAILED,
        NO_MATCHING_JAR;

    }

    private static final class SelectionResult {
        private final ContainedJarIdentifier identifier;
        private final Optional<ContainedJarMetadata> selected;
        private final boolean noValidRangeFound;

        private SelectionResult(ContainedJarIdentifier identifier, Optional<ContainedJarMetadata> selected, boolean noValidRangeFound) {
            this.identifier = identifier;
            this.selected = selected;
            this.noValidRangeFound = noValidRangeFound;
        }

        public ContainedJarIdentifier identifier() {
            return this.identifier;
        }

        public Optional<ContainedJarMetadata> selected() {
            return this.selected;
        }

        public boolean noValidRangeFound() {
            return this.noValidRangeFound;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SelectionResult that = (SelectionResult)obj;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.selected, that.selected);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.selected);
        }

        public String toString() {
            return "SelectionResult[identifier=" + this.identifier + ", selected=" + this.selected + ']';
        }
    }

    private static final class DetectionResult<Z> {
        private final ContainedJarMetadata metadata;
        private final Z source;
        private final byte depth;

        private DetectionResult(ContainedJarMetadata metadata, Z source, byte depth) {
            this.metadata = metadata;
            this.source = source;
            this.depth = depth;
        }

        private Z source() {
            return this.source;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DetectionResult that = (DetectionResult)obj;
            return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.source, that.source) && this.depth == that.depth;
        }

        public int hashCode() {
            return Objects.hash(this.metadata, this.source, this.depth);
        }

        public String toString() {
            return "DetectionResult[metadata=" + this.metadata + ", source=" + this.source + ", depth=" + this.depth + ']';
        }
    }
}

