/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.selection;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.ContainedVersion;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.MetadataIOHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarSelector.class);
    public static final String CONTAINED_JARS_METADATA_PATH = "META-INF/jarjar/metadata.json";

    private JarSelector() {
    }

    public static <T, E extends Throwable> List<T> detectAndSelect(List<T> source, BiFunction<T, Path, Optional<InputStream>> resourceReader, BiFunction<T, Path, Optional<T>> sourceProducer, Function<T, String> identificationProducer, Function<Collection<ResolutionFailureInformation<T>>, E> failureExceptionProducer) throws E {
        Set<DetectionResult<T>> detectedMetadata = JarSelector.detect(source, resourceReader, sourceProducer, identificationProducer);
        Multimap detectedJarsBySource = (Multimap)detectedMetadata.stream().collect(Multimaps.toMultimap(DetectionResult::metadata, DetectionResult::source, HashMultimap::create));
        Multimap detectedJarsByRootSource = (Multimap)detectedMetadata.stream().collect(Multimaps.toMultimap(DetectionResult::metadata, DetectionResult::rootSource, HashMultimap::create));
        ImmutableListMultimap metadataByIdentifier = Multimaps.index((Iterable)detectedJarsByRootSource.keySet(), ContainedJarMetadata::identifier);
        Set<SelectionResult> select = JarSelector.select(detectedJarsBySource.keySet());
        if (select.stream().anyMatch(result -> !result.selected().isPresent())) {
            Set failed = select.stream().filter(result -> !result.selected().isPresent()).collect(Collectors.toSet());
            ArrayList resolutionFailures = new ArrayList();
            for (SelectionResult failedResult : failed) {
                ContainedJarIdentifier failedIdentifier = failedResult.identifier();
                Collection metadata = metadataByIdentifier.get((Object)failedIdentifier);
                Set sources = metadata.stream().map(containedJarMetadata -> {
                    Collection rootSources = detectedJarsBySource.get(containedJarMetadata);
                    return new SourceWithRequestedVersionRange(rootSources, containedJarMetadata.version().range(), containedJarMetadata.version().artifactVersion());
                }).collect(Collectors.toSet());
                ResolutionFailureInformation resolutionFailure = new ResolutionFailureInformation(JarSelector.getFailureReason(failedResult), failedIdentifier, sources);
                resolutionFailures.add(resolutionFailure);
            }
            Throwable exception = (Throwable)failureExceptionProducer.apply(resolutionFailures);
            LOGGER.error("Failed to select jars for {}", resolutionFailures);
            throw exception;
        }
        ArrayList selectedJars = new ArrayList(select.size());
        for (SelectionResult result2 : select) {
            ContainedJarMetadata selectedJarMetadata;
            Optional<ContainedJarMetadata> optional = result2.selected();
            if (!optional.isPresent() || !detectedJarsBySource.containsKey((Object)(selectedJarMetadata = optional.get()))) continue;
            Collection sourceOfJar = detectedJarsBySource.get((Object)selectedJarMetadata);
            Optional<Object> s = sourceProducer.apply(sourceOfJar.iterator().next(), Paths.get(selectedJarMetadata.path(), new String[0]));
            s.ifPresent(selectedJars::add);
        }
        Map selectedJarsByIdentification = selectedJars.stream().collect(Collectors.toMap(identificationProducer, Function.identity(), (t, t2) -> {
            LOGGER.warn("Attempted to select two dependency jars from JarJar which have the same identification: {} and {}. Using {}", new Object[]{t, t2, t});
            return t;
        }));
        Map sourceJarsByIdentification = source.stream().collect(Collectors.toMap(identificationProducer, Function.identity(), (t, t2) -> {
            LOGGER.warn("Attempted to select two source jars for JarJar which have the same identification: {} and {}. Using {}", new Object[]{t, t2, t});
            return t;
        }));
        Iterator<String> itor = selectedJarsByIdentification.keySet().iterator();
        while (itor.hasNext()) {
            String identification = itor.next();
            Object sourceJar = sourceJarsByIdentification.get(identification);
            if (sourceJar == null) continue;
            LOGGER.warn("Attempted to select a dependency jar for JarJar which was passed in as source: {}. Using {}", (Object)identification, sourceJar);
            itor.remove();
        }
        return new ArrayList(selectedJarsByIdentification.values());
    }

    private static <T> Set<DetectionResult<T>> detect(List<T> source, BiFunction<T, Path, Optional<InputStream>> resourceReader, BiFunction<T, Path, Optional<T>> sourceProducer, Function<T, String> identificationProducer) {
        Path metadataPath = Paths.get(CONTAINED_JARS_METADATA_PATH, new String[0]);
        Map metadataInputStreamsBySource = source.stream().collect(Collectors.toMap(Function.identity(), t -> (Optional)resourceReader.apply(t, metadataPath)));
        Map<Object, Metadata> rootMetadataBySource = metadataInputStreamsBySource.entrySet().stream().filter(kvp -> ((Optional)kvp.getValue()).isPresent()).map(kvp -> new SourceWithOptionalMetadata(kvp.getKey(), MetadataIOHandler.fromStream((InputStream)((InputStream)((Optional)kvp.getValue()).get())))).filter(sourceWithOptionalMetadata -> sourceWithOptionalMetadata.metadata().isPresent()).collect(Collectors.toMap(SourceWithOptionalMetadata::source, sourceWithOptionalMetadata -> sourceWithOptionalMetadata.metadata().get()));
        return JarSelector.recursivelyDetectContainedJars(rootMetadataBySource, resourceReader, sourceProducer, identificationProducer);
    }

    private static <T> Set<DetectionResult<T>> recursivelyDetectContainedJars(Map<T, Metadata> rootMetadataBySource, BiFunction<T, Path, Optional<InputStream>> resourceReader, BiFunction<T, Path, Optional<T>> sourceProducer, Function<T, String> identificationProducer) {
        HashSet results = Sets.newHashSet();
        HashMap rootSourcesBySource = Maps.newHashMap();
        LinkedList<T> sourcesToProcess = new LinkedList<T>();
        for (Map.Entry entry : rootMetadataBySource.entrySet()) {
            entry.getValue().jars().stream().map(containedJarMetadata -> new DetectionResult((ContainedJarMetadata)containedJarMetadata, entry.getKey(), entry.getKey())).forEach(results::add);
            for (ContainedJarMetadata jar : entry.getValue().jars()) {
                Optional<T> source = sourceProducer.apply(entry.getKey(), Paths.get(jar.path(), new String[0]));
                if (source.isPresent()) {
                    sourcesToProcess.add(source.get());
                    rootSourcesBySource.put(source.get(), entry.getKey());
                    continue;
                }
                LOGGER.warn("The source jar: " + identificationProducer.apply(entry.getKey()) + " is supposed to contain a jar: " + jar.path() + " but it does not exist.");
            }
        }
        while (!sourcesToProcess.isEmpty()) {
            Optional metadata;
            Object source = sourcesToProcess.remove();
            Object rootSource = rootSourcesBySource.get(source);
            Optional<InputStream> metadataInputStream = resourceReader.apply(source, Paths.get(CONTAINED_JARS_METADATA_PATH, new String[0]));
            if (!metadataInputStream.isPresent() || !(metadata = MetadataIOHandler.fromStream((InputStream)metadataInputStream.get())).isPresent()) continue;
            ((Metadata)metadata.get()).jars().stream().map(containedJarMetadata -> new DetectionResult((ContainedJarMetadata)containedJarMetadata, source, rootSource)).forEach(results::add);
            for (ContainedJarMetadata jar : ((Metadata)metadata.get()).jars()) {
                Optional<T> sourceJar = sourceProducer.apply(source, Paths.get(jar.path(), new String[0]));
                if (sourceJar.isPresent()) {
                    sourcesToProcess.add(sourceJar.get());
                    rootSourcesBySource.put(sourceJar.get(), rootSource);
                    continue;
                }
                LOGGER.warn("The source jar: " + identificationProducer.apply(source) + " is supposed to contain a jar: " + jar.path() + " but it does not exist.");
            }
        }
        return results;
    }

    private static Set<SelectionResult> select(Set<ContainedJarMetadata> containedJarMetadata) {
        Multimap jarsByIdentifier = (Multimap)containedJarMetadata.stream().collect(Multimaps.toMultimap(ContainedJarMetadata::identifier, Function.identity(), HashMultimap::create));
        return jarsByIdentifier.keySet().stream().map(identifier -> {
            Collection jars = jarsByIdentifier.get(identifier);
            if (jars.size() <= 1) {
                return new SelectionResult((ContainedJarIdentifier)identifier, jars, Optional.of(jars.iterator().next()), false);
            }
            VersionRange range = jars.stream().map(ContainedJarMetadata::version).map(ContainedVersion::range).reduce(null, JarSelector::restrictRanges);
            if (range == null || !JarSelector.isValid(range)) {
                return new SelectionResult((ContainedJarIdentifier)identifier, jars, Optional.empty(), true);
            }
            if (range.getRecommendedVersion() != null) {
                Optional<ContainedJarMetadata> selected = jars.stream().filter(jar -> jar.version().artifactVersion().equals(range.getRecommendedVersion())).findFirst();
                return new SelectionResult((ContainedJarIdentifier)identifier, jars, selected, false);
            }
            Optional<ContainedJarMetadata> selected = jars.stream().filter(jar -> range.containsVersion(jar.version().artifactVersion())).findFirst();
            return new SelectionResult((ContainedJarIdentifier)identifier, jars, selected, false);
        }).collect(Collectors.toSet());
    }

    private static VersionRange restrictRanges(VersionRange versionRange, VersionRange versionRange2) {
        if (versionRange == null) {
            return versionRange2;
        }
        if (versionRange2 == null) {
            return versionRange;
        }
        return versionRange.restrict(versionRange2);
    }

    private static boolean isValid(VersionRange range) {
        return range.getRecommendedVersion() == null && range.hasRestrictions();
    }

    private static FailureReason getFailureReason(SelectionResult selectionResult) {
        if (selectionResult.selected().isPresent()) {
            throw new IllegalArgumentException("Resolution succeeded, not failure possible");
        }
        if (selectionResult.noValidRangeFound()) {
            return FailureReason.VERSION_RESOLUTION_FAILED;
        }
        return FailureReason.NO_MATCHING_JAR;
    }

    public static final class ResolutionFailureInformation<Z> {
        private final FailureReason failureReason;
        private final ContainedJarIdentifier identifier;
        private final Collection<SourceWithRequestedVersionRange<Z>> sources;

        public ResolutionFailureInformation(FailureReason failureReason, ContainedJarIdentifier identifier, Collection<SourceWithRequestedVersionRange<Z>> sources) {
            this.failureReason = failureReason;
            this.identifier = identifier;
            this.sources = sources;
        }

        public FailureReason failureReason() {
            return this.failureReason;
        }

        public ContainedJarIdentifier identifier() {
            return this.identifier;
        }

        public Collection<SourceWithRequestedVersionRange<Z>> sources() {
            return this.sources;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResolutionFailureInformation)) {
                return false;
            }
            ResolutionFailureInformation that = (ResolutionFailureInformation)o;
            if (this.failureReason != that.failureReason) {
                return false;
            }
            if (!this.identifier.equals((Object)that.identifier)) {
                return false;
            }
            return this.sources.equals(that.sources);
        }

        public int hashCode() {
            int result = this.failureReason.hashCode();
            result = 31 * result + this.identifier.hashCode();
            result = 31 * result + this.sources.hashCode();
            return result;
        }

        public String toString() {
            return "ResolutionFailureInformation{failureReason=" + (Object)((Object)this.failureReason) + ", identifier=" + this.identifier + ", sources=" + this.sources + '}';
        }
    }

    public static final class SourceWithRequestedVersionRange<Z> {
        private final Collection<Z> sources;
        private final VersionRange requestedVersionRange;
        private final ArtifactVersion includedVersion;

        public SourceWithRequestedVersionRange(Collection<Z> sources, VersionRange requestedVersionRange, ArtifactVersion includedVersion) {
            this.sources = sources;
            this.requestedVersionRange = requestedVersionRange;
            this.includedVersion = includedVersion;
        }

        public Collection<Z> sources() {
            return this.sources;
        }

        public VersionRange requestedVersionRange() {
            return this.requestedVersionRange;
        }

        public ArtifactVersion includedVersion() {
            return this.includedVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceWithRequestedVersionRange)) {
                return false;
            }
            SourceWithRequestedVersionRange that = (SourceWithRequestedVersionRange)o;
            if (!this.sources.equals(that.sources)) {
                return false;
            }
            if (!this.requestedVersionRange.equals((Object)that.requestedVersionRange)) {
                return false;
            }
            return this.includedVersion.equals(that.includedVersion);
        }

        public int hashCode() {
            int result = this.sources.hashCode();
            result = 31 * result + this.requestedVersionRange.hashCode();
            result = 31 * result + this.includedVersion.hashCode();
            return result;
        }

        public String toString() {
            return "SourceWithRequestedVersionRange{source=" + this.sources + ", requestedVersionRange=" + this.requestedVersionRange + ", includedVersion=" + this.includedVersion + '}';
        }
    }

    public static enum FailureReason {
        VERSION_RESOLUTION_FAILED,
        NO_MATCHING_JAR;

    }

    private static final class SelectionResult {
        private final ContainedJarIdentifier identifier;
        private final Collection<ContainedJarMetadata> candidates;
        private final Optional<ContainedJarMetadata> selected;
        private final boolean noValidRangeFound;

        private SelectionResult(ContainedJarIdentifier identifier, Collection<ContainedJarMetadata> candidates, Optional<ContainedJarMetadata> selected, boolean noValidRangeFound) {
            this.identifier = identifier;
            this.candidates = candidates;
            this.selected = selected;
            this.noValidRangeFound = noValidRangeFound;
        }

        public ContainedJarIdentifier identifier() {
            return this.identifier;
        }

        public Collection<ContainedJarMetadata> candidates() {
            return this.candidates;
        }

        public Optional<ContainedJarMetadata> selected() {
            return this.selected;
        }

        public boolean noValidRangeFound() {
            return this.noValidRangeFound;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SelectionResult that = (SelectionResult)obj;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.candidates, that.candidates) && Objects.equals(this.selected, that.selected);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.candidates, this.selected);
        }

        public String toString() {
            return "SelectionResult[identifier=" + this.identifier + ", candidates=" + this.candidates + ", selected=" + this.selected + ']';
        }
    }

    private static final class DetectionResult<Z> {
        private final ContainedJarMetadata metadata;
        private final Z source;
        private final Z rootSource;

        private DetectionResult(ContainedJarMetadata metadata, Z source, Z rootSource) {
            this.metadata = metadata;
            this.source = source;
            this.rootSource = rootSource;
        }

        public ContainedJarMetadata metadata() {
            return this.metadata;
        }

        public Z source() {
            return this.source;
        }

        public Z rootSource() {
            return this.rootSource;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DetectionResult that = (DetectionResult)obj;
            return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.source, that.source) && Objects.equals(this.rootSource, that.rootSource);
        }

        public int hashCode() {
            return Objects.hash(this.metadata, this.source, this.rootSource);
        }

        public String toString() {
            return "DetectionResult[metadata=" + this.metadata + ", source=" + this.source + ", rootSource=" + this.rootSource + ']';
        }
    }

    private static final class SourceWithOptionalMetadata<Z> {
        private final Z source;
        private final Optional<Metadata> metadata;

        SourceWithOptionalMetadata(Z source, Optional<Metadata> metadata) {
            this.source = source;
            this.metadata = metadata;
        }

        public Z source() {
            return this.source;
        }

        public Optional<Metadata> metadata() {
            return this.metadata;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SourceWithOptionalMetadata that = (SourceWithOptionalMetadata)obj;
            return Objects.equals(this.source, that.source) && Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.metadata);
        }

        public String toString() {
            return "SourceWithOptionalMetadata[source=" + this.source + ", metadata=" + this.metadata + ']';
        }
    }
}

