/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.metadata.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;

public class VersionRangeSerializer
implements JsonSerializer<VersionRange>,
JsonDeserializer<VersionRange> {
    @Override
    public VersionRange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            try {
                return VersionRange.createFromVersionSpec(json.getAsString());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new JsonParseException("Failed to parse version spec from: " + json.getAsString(), e);
            }
        }
        throw new JsonParseException("Expected a string or primitive value");
    }

    @Override
    public JsonElement serialize(VersionRange src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(VersionRangeSerializer.serializeRange(src));
    }

    private static String serializeRange(VersionRange src) {
        return src.getRecommendedVersion() != null ? src.getRecommendedVersion().toString() : src.getRestrictions().stream().map(VersionRangeSerializer::serializeRestriction).collect(Collectors.joining(","));
    }

    private static String serializeRestriction(Restriction src) {
        return src.getLowerBound().equals(src.getUpperBound()) ? String.format("%s%s%s", Character.valueOf(src.isLowerBoundInclusive() ? (char)'[' : '('), src.getLowerBound().toString(), Character.valueOf(src.isUpperBoundInclusive() ? (char)']' : ')')) : src.toString();
    }
}

