/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.metadata.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;

public class ContainedJarIdentifierSerializer
implements JsonSerializer<ContainedJarIdentifier>,
JsonDeserializer<ContainedJarIdentifier> {
    @Override
    public ContainedJarIdentifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected object");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String group = jsonObject.get("group").getAsString();
        String artifact = jsonObject.get("artifact").getAsString();
        return new ContainedJarIdentifier(group, artifact);
    }

    @Override
    public JsonElement serialize(ContainedJarIdentifier src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("group", src.group());
        jsonObject.addProperty("artifact", src.artifact());
        return jsonObject;
    }
}

