/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.ContainedVersion;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.json.ArtifactVersionSerializer;
import net.minecraftforge.jarjar.metadata.json.ContainedJarIdentifierSerializer;
import net.minecraftforge.jarjar.metadata.json.ContainedJarMetadataSerializer;
import net.minecraftforge.jarjar.metadata.json.ContainedVersionSerializer;
import net.minecraftforge.jarjar.metadata.json.MetadataSerializer;
import net.minecraftforge.jarjar.metadata.json.VersionRangeSerializer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataIOHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataIOHandler.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)VersionRange.class), new VersionRangeSerializer()).registerTypeAdapter((Type)((Object)ArtifactVersion.class), new ArtifactVersionSerializer()).registerTypeAdapter((Type)((Object)DefaultArtifactVersion.class), new ArtifactVersionSerializer()).registerTypeAdapter((Type)((Object)ContainedJarIdentifier.class), new ContainedJarIdentifierSerializer()).registerTypeAdapter((Type)((Object)ContainedJarMetadata.class), new ContainedJarMetadataSerializer()).registerTypeAdapter((Type)((Object)ContainedVersion.class), new ContainedVersionSerializer()).registerTypeAdapter((Type)((Object)Metadata.class), new MetadataSerializer()).setPrettyPrinting().create();

    private MetadataIOHandler() {
    }

    public static Gson getGson() {
        return GSON;
    }

    public static Optional<Metadata> fromStream(InputStream stream) {
        try {
            return Optional.of(GSON.fromJson((Reader)new InputStreamReader(stream), Metadata.class));
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse metadata", e);
            return Optional.empty();
        }
    }

    public static Iterable<String> toLines(Metadata metadata) {
        return Arrays.asList(GSON.toJson(metadata).split("\n"));
    }

    public static InputStream toInputStream(Metadata metadata) {
        String values = GSON.toJson(metadata);
        return new ByteArrayInputStream(values.getBytes());
    }
}

