/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.relocated.net.minecraftforge.srgutils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import net.minecraftforge.fart.relocated.net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.fart.relocated.net.minecraftforge.srgutils.IRenamer;
import net.minecraftforge.fart.relocated.net.minecraftforge.srgutils.InternalUtils;
import net.minecraftforge.fart.relocated.net.minecraftforge.srgutils.NamedMappingFile;
import org.jetbrains.annotations.Nullable;

class MappingFile
implements IMappingFile {
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Collection<Package> packagesView = Collections.unmodifiableCollection(this.packages.values());
    private Map<String, Cls> classes = new HashMap<String, Cls>();
    private Collection<Cls> classesView = Collections.unmodifiableCollection(this.classes.values());
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();
    static final Pattern DESC = Pattern.compile("L(?<cls>[^;]+);");

    MappingFile() {
    }

    MappingFile(NamedMappingFile source, int from, int to) {
        source.getPackages().forEach(pkg -> this.addPackage(pkg.getName(from), pkg.getName(to), pkg.meta));
        source.getClasses().forEach(cls -> {
            Cls c = this.addClass(cls.getName(from), cls.getName(to), cls.meta);
            cls.getFields().forEach(fld -> c.addField(fld.getName(from), fld.getName(to), fld.getDescriptor(from), fld.meta));
            cls.getMethods().forEach(mtd -> {
                Cls.Method m = c.addMethod(mtd.getName(from), mtd.getDescriptor(from), mtd.getName(to), mtd.meta);
                mtd.getParameters().forEach(par -> m.addParameter(par.getIndex(), par.getName(from), par.getName(to), par.meta));
            });
        });
    }

    public Collection<Package> getPackages() {
        return this.packagesView;
    }

    @Override
    @Nullable
    public Package getPackage(String original) {
        return this.packages.get(original);
    }

    private Package addPackage(String original, String mapped, Map<String, String> metadata) {
        return this.packages.put(original, new Package(original, mapped, metadata));
    }

    public Collection<Cls> getClasses() {
        return this.classesView;
    }

    @Override
    @Nullable
    public Cls getClass(String original) {
        return this.classes.get(original);
    }

    private Cls addClass(String original, String mapped, Map<String, String> metadata) {
        return MappingFile.retPut(this.classes, original, new Cls(original, mapped, metadata));
    }

    @Override
    public String remapPackage(String pkg) {
        Package ipkg = this.packages.get(pkg);
        return ipkg == null ? pkg : ipkg.getMapped();
    }

    @Override
    public String remapClass(String cls) {
        String ret = this.cache.get(cls);
        if (ret == null) {
            int idx;
            Cls _cls = this.classes.get(cls);
            ret = _cls == null ? ((idx = cls.lastIndexOf(36)) != -1 ? this.remapClass(cls.substring(0, idx)) + '$' + cls.substring(idx + 1) : cls) : _cls.getMapped();
            this.cache.put(cls, ret);
        }
        return ret;
    }

    @Override
    public String remapDescriptor(String desc) {
        Matcher matcher = DESC.matcher(desc);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement("L" + this.remapClass(matcher.group("cls")) + ";"));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @Override
    public void write(Path path, IMappingFile.Format format, boolean reversed) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Comparator sort = reversed ? (a, b) -> a.getMapped().compareTo(b.getMapped()) : (a, b) -> a.getOriginal().compareTo(b.getOriginal());
        this.getPackages().stream().sorted(sort).forEachOrdered(pkg -> MappingFile.write(lines, format, reversed, InternalUtils.Element.PACKAGE, pkg));
        this.getClasses().stream().sorted(sort).forEachOrdered(cls -> {
            MappingFile.write(lines, format, reversed, InternalUtils.Element.CLASS, cls);
            cls.getFields().stream().sorted(sort).forEachOrdered(fld -> MappingFile.write(lines, format, reversed, InternalUtils.Element.FIELD, fld));
            cls.getMethods().stream().sorted(sort).forEachOrdered(mtd -> {
                MappingFile.write(lines, format, reversed, InternalUtils.Element.METHOD, mtd);
                mtd.getParameters().stream().sorted((a, b) -> a.getIndex() - b.getIndex()).forEachOrdered(par -> MappingFile.write(lines, format, reversed, InternalUtils.Element.PARAMETER, par));
            });
        });
        lines.removeIf(Objects::isNull);
        if (!format.isOrdered()) {
            Comparator linesort = format == IMappingFile.Format.SRG || format == IMappingFile.Format.XSRG ? InternalUtils::compareLines : (o1, o2) -> o1.compareTo((String)o2);
            lines.sort(linesort);
        }
        switch (format) {
            case TINY1: {
                lines.add(0, "v1\tleft\tright");
                break;
            }
            case TINY: {
                lines.add(0, "tiny\t2\t0\tleft\tright");
                break;
            }
            case TSRG2: {
                lines.add(0, "tsrg2 left right");
                break;
            }
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream fos = Files.newOutputStream(path, new OpenOption[0]);){
            OutputStream out = fos;
            if (path.getFileName().toString().endsWith(".gz")) {
                out = new GZIPOutputStream(out);
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
                for (String line : lines) {
                    writer.write(line);
                    writer.write(10);
                }
            }
        }
    }

    private static void write(List<String> lines, IMappingFile.Format format, boolean reversed, InternalUtils.Element element, IMappingFile.INode node) {
        String line = node.write(format, reversed);
        if (line != null) {
            lines.add(line);
            InternalUtils.writeMeta(format, lines, element, node.getMetadata());
        }
    }

    @Override
    public MappingFile reverse() {
        MappingFile ret = new MappingFile();
        this.getPackages().forEach(pkg -> ret.addPackage(pkg.getMapped(), pkg.getOriginal(), pkg.getMetadata()));
        this.getClasses().forEach(cls -> {
            Cls c = ret.addClass(cls.getMapped(), cls.getOriginal(), cls.getMetadata());
            cls.getFields().forEach(fld -> c.addField(fld.getMapped(), fld.getOriginal(), fld.getMappedDescriptor(), fld.getMetadata()));
            cls.getMethods().forEach(mtd -> {
                Cls.Method m = c.addMethod(mtd.getMapped(), mtd.getMappedDescriptor(), mtd.getOriginal(), mtd.getMetadata());
                mtd.getParameters().forEach(par -> m.addParameter(par.getIndex(), par.getMapped(), par.getOriginal(), par.getMetadata()));
            });
        });
        return ret;
    }

    @Override
    public MappingFile rename(IRenamer renamer) {
        MappingFile ret = new MappingFile();
        this.getPackages().forEach(pkg -> ret.addPackage(pkg.getOriginal(), renamer.rename((IMappingFile.IPackage)pkg), pkg.getMetadata()));
        this.getClasses().forEach(cls -> {
            Cls c = ret.addClass(cls.getOriginal(), renamer.rename((IMappingFile.IClass)cls), cls.getMetadata());
            cls.getFields().forEach(fld -> c.addField(fld.getOriginal(), renamer.rename((IMappingFile.IField)fld), fld.getDescriptor(), fld.getMetadata()));
            cls.getMethods().forEach(mtd -> {
                Cls.Method m = c.addMethod(mtd.getOriginal(), mtd.getDescriptor(), renamer.rename((IMappingFile.IMethod)mtd), mtd.getMetadata());
                mtd.getParameters().forEach(par -> m.addParameter(par.getIndex(), par.getOriginal(), renamer.rename((IMappingFile.IParameter)par), par.getMetadata()));
            });
        });
        return ret;
    }

    @Override
    public MappingFile chain(final IMappingFile link) {
        return this.rename(new IRenamer(){

            @Override
            public String rename(IMappingFile.IPackage value) {
                return link.remapPackage(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IClass value) {
                return link.remapClass(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IField value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null ? value.getMapped() : cls.remapField(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IMethod value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null ? value.getMapped() : cls.remapMethod(value.getMapped(), value.getMappedDescriptor());
            }

            @Override
            public String rename(IMappingFile.IParameter value) {
                IMappingFile.IMethod mtd = (IMappingFile.IMethod)value.getParent();
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)mtd.getParent()).getMapped());
                mtd = cls == null ? null : cls.getMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                return mtd == null ? value.getMapped() : mtd.remapParameter(value.getIndex(), value.getMapped());
            }
        });
    }

    @Override
    public MappingFile merge(IMappingFile other) {
        MappingFile ret = new MappingFile();
        this.getPackages().forEach(pkg -> ret.addPackage(pkg.getOriginal(), pkg.getMapped(), pkg.getMetadata()));
        this.getClasses().forEach(cls -> MappingFile.copyClass(ret, cls));
        other.getPackages().forEach(pkg -> {
            Package existingPkg = ret.getPackage(pkg.getOriginal());
            if (existingPkg == null) {
                ret.addPackage(pkg.getOriginal(), pkg.getMapped(), pkg.getMetadata());
            } else {
                ret.addPackage(pkg.getOriginal(), existingPkg.getMapped(), MappingFile.mergeMetadata(existingPkg.getMetadata(), pkg.getMetadata()));
            }
        });
        other.getClasses().forEach(cls -> {
            Cls existingCls = ret.getClass(cls.getOriginal());
            if (existingCls == null) {
                MappingFile.copyClass(ret, cls);
                return;
            }
            Cls newCls = ret.addClass(cls.getOriginal(), existingCls.getMapped(), MappingFile.mergeMetadata(existingCls.getMetadata(), cls.getMetadata()));
            newCls.methods.putAll(existingCls.methods);
            newCls.fields.putAll(existingCls.fields);
            cls.getFields().forEach(fld -> {
                IMappingFile.IField existingFld = existingCls.getField(fld.getOriginal());
                if (existingFld == null) {
                    newCls.addField(fld.getOriginal(), fld.getMapped(), fld.getDescriptor(), fld.getMetadata());
                } else {
                    newCls.addField(fld.getOriginal(), existingFld.getMapped(), existingFld.getDescriptor(), MappingFile.mergeMetadata(existingFld.getMetadata(), fld.getMetadata()));
                }
            });
            cls.getMethods().forEach(mtd -> {
                Cls.Method existingMtd = existingCls.getMethod(mtd.getOriginal(), mtd.getDescriptor());
                if (existingMtd == null) {
                    MappingFile.copyMethod(newCls, mtd);
                    return;
                }
                Cls.Method newMtd = newCls.addMethod(mtd.getOriginal(), existingMtd.getDescriptor(), existingMtd.getMapped(), MappingFile.mergeMetadata(existingMtd.getMetadata(), mtd.getMetadata()));
                newMtd.params.putAll(existingMtd.params);
                mtd.getParameters().forEach(par -> {
                    IMappingFile.IParameter existingPar = existingMtd.getParameter(par.getIndex());
                    if (existingPar == null) {
                        newMtd.addParameter(par.getIndex(), par.getOriginal(), par.getMapped(), par.getMetadata());
                    } else {
                        newMtd.addParameter(par.getIndex(), par.getOriginal(), existingPar.getMapped(), MappingFile.mergeMetadata(existingPar.getMetadata(), par.getMetadata()));
                    }
                });
            });
        });
        return ret;
    }

    private static void copyClass(MappingFile ret, IMappingFile.IClass cls) {
        Cls c = ret.addClass(cls.getOriginal(), cls.getMapped(), cls.getMetadata());
        cls.getFields().forEach(fld -> c.addField(fld.getOriginal(), fld.getMapped(), fld.getDescriptor(), fld.getMetadata()));
        cls.getMethods().forEach(mtd -> MappingFile.copyMethod(c, mtd));
    }

    private static void copyMethod(Cls c, IMappingFile.IMethod mtd) {
        Cls.Method m = c.addMethod(mtd.getOriginal(), mtd.getDescriptor(), mtd.getMapped(), mtd.getMetadata());
        mtd.getParameters().forEach(par -> m.addParameter(par.getIndex(), par.getOriginal(), par.getMapped(), par.getMetadata()));
    }

    private static Map<String, String> mergeMetadata(Map<String, String> base, Map<String, String> extra) {
        HashMap<String, String> merged = new HashMap<String, String>(base);
        for (Map.Entry<String, String> entry : extra.entrySet()) {
            if (merged.containsKey(entry.getKey())) continue;
            merged.put(entry.getKey(), entry.getValue());
        }
        return merged;
    }

    private static <K, V> V retPut(Map<K, V> map, K key, V value) {
        map.put(key, value);
        return value;
    }

    class Cls
    extends Node
    implements IMappingFile.IClass {
        private Map<String, Field> fields;
        private Collection<Field> fieldsView;
        private Map<String, Method> methods;
        private Collection<Method> methodsView;

        protected Cls(String original, String mapped, Map<String, String> metadata) {
            super(original, mapped, metadata);
            this.fields = new HashMap<String, Field>();
            this.fieldsView = Collections.unmodifiableCollection(this.fields.values());
            this.methods = new HashMap<String, Method>();
            this.methodsView = Collections.unmodifiableCollection(this.methods.values());
        }

        @Override
        @Nullable
        public String write(IMappingFile.Format format, boolean reversed) {
            String oName = !reversed ? this.getOriginal() : this.getMapped();
            String mName = !reversed ? this.getMapped() : this.getOriginal();
            switch (format) {
                case SRG: 
                case XSRG: {
                    return "CL: " + oName + ' ' + mName;
                }
                case TSRG2: 
                case CSRG: 
                case TSRG: {
                    return oName + ' ' + mName;
                }
                case PG: {
                    return oName.replace('/', '.') + " -> " + mName.replace('/', '.') + ':';
                }
                case TINY1: {
                    return "CLASS\t" + oName + '\t' + mName;
                }
                case TINY: {
                    return "c\t" + oName + '\t' + mName;
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        public Collection<Field> getFields() {
            return this.fieldsView;
        }

        @Override
        @Nullable
        public IMappingFile.IField getField(String name) {
            return this.fields.get(name);
        }

        @Override
        public String remapField(String field) {
            Field fld = this.fields.get(field);
            return fld == null ? field : fld.getMapped();
        }

        private Field addField(String original, String mapped, String desc, Map<String, String> metadata) {
            return (Field)MappingFile.retPut(this.fields, original, new Field(original, mapped, desc, metadata));
        }

        public Collection<Method> getMethods() {
            return this.methodsView;
        }

        @Override
        @Nullable
        public Method getMethod(String name, String desc) {
            return this.methods.get(name + desc);
        }

        private Method addMethod(String original, String desc, String mapped, Map<String, String> metadata) {
            return (Method)MappingFile.retPut(this.methods, original + desc, new Method(original, desc, mapped, metadata));
        }

        @Override
        public String remapMethod(String name, String desc) {
            Method mtd = this.methods.get(name + desc);
            return mtd == null ? name : mtd.getMapped();
        }

        public String toString() {
            return this.write(IMappingFile.Format.SRG, false);
        }

        class Method
        extends Node
        implements IMappingFile.IMethod {
            private final String desc;
            private final Map<Integer, Parameter> params;
            private final Collection<Parameter> paramsView;

            private Method(String original, String desc, String mapped, Map<String, String> metadata) {
                super(original, mapped, metadata);
                this.params = new HashMap<Integer, Parameter>();
                this.paramsView = Collections.unmodifiableCollection(this.params.values());
                this.desc = desc;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            @Override
            public String getMappedDescriptor() {
                return MappingFile.this.remapDescriptor(this.desc);
            }

            public Collection<Parameter> getParameters() {
                return this.paramsView;
            }

            private Parameter addParameter(int index, String original, String mapped, Map<String, String> metadata) {
                return (Parameter)MappingFile.retPut(this.params, index, new Parameter(index, original, mapped, metadata));
            }

            @Override
            @Nullable
            public IMappingFile.IParameter getParameter(int index) {
                return this.params.get(index);
            }

            @Override
            public String remapParameter(int index, String name) {
                Parameter param = this.params.get(index);
                return param == null ? name : param.getMapped();
            }

            @Override
            public String write(IMappingFile.Format format, boolean reversed) {
                String oName = !reversed ? this.getOriginal() : this.getMapped();
                String mName = !reversed ? this.getMapped() : this.getOriginal();
                String oOwner = !reversed ? Cls.this.getOriginal() : Cls.this.getMapped();
                String mOwner = !reversed ? Cls.this.getMapped() : Cls.this.getOriginal();
                String oDesc = !reversed ? this.getDescriptor() : this.getMappedDescriptor();
                String mDesc = !reversed ? this.getMappedDescriptor() : this.getDescriptor();
                switch (format) {
                    case SRG: 
                    case XSRG: {
                        return "MD: " + oOwner + '/' + oName + ' ' + oDesc + ' ' + mOwner + '/' + mName + ' ' + mDesc;
                    }
                    case CSRG: {
                        return oOwner + ' ' + oName + ' ' + oDesc + ' ' + mName;
                    }
                    case TSRG2: 
                    case TSRG: {
                        return '\t' + oName + ' ' + oDesc + ' ' + mName;
                    }
                    case TINY1: {
                        return "METHOD\t" + oOwner + '\t' + oDesc + '\t' + oName + '\t' + mName;
                    }
                    case TINY: {
                        return "\tm\t" + oDesc + '\t' + oName + '\t' + mName;
                    }
                    case PG: {
                        int start = Integer.parseInt(this.getMetadata().getOrDefault("start_line", "0"));
                        int end = Integer.parseInt(this.getMetadata().getOrDefault("end_line", "0"));
                        return "    " + (start == 0 && end == 0 ? "" : start + ":" + end + ":") + InternalUtils.toSource(oName, oDesc) + " -> " + mName;
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }

            public String toString() {
                return this.write(IMappingFile.Format.SRG, false);
            }

            @Override
            public Cls getParent() {
                return Cls.this;
            }

            class Parameter
            extends Node
            implements IMappingFile.IParameter {
                private final int index;

                protected Parameter(int index, String original, String mapped, Map<String, String> metadata) {
                    super(original, mapped, metadata);
                    this.index = index;
                }

                @Override
                public IMappingFile.IMethod getParent() {
                    return Method.this;
                }

                @Override
                public int getIndex() {
                    return this.index;
                }

                @Override
                public String write(IMappingFile.Format format, boolean reversed) {
                    String oName = !reversed ? this.getOriginal() : this.getMapped();
                    String mName = !reversed ? this.getMapped() : this.getOriginal();
                    switch (format) {
                        case TINY1: 
                        case SRG: 
                        case XSRG: 
                        case CSRG: 
                        case TSRG: 
                        case PG: {
                            return null;
                        }
                        case TINY: {
                            return "\t\tp\t" + this.getIndex() + '\t' + oName + '\t' + mName;
                        }
                        case TSRG2: {
                            return "\t\t" + this.getIndex() + ' ' + oName + ' ' + mName;
                        }
                    }
                    throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
                }
            }
        }

        class Field
        extends Node
        implements IMappingFile.IField {
            private final String desc;

            private Field(String original, String mapped, String desc, Map<String, String> metadata) {
                super(original, mapped, metadata);
                this.desc = desc;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            @Override
            public String getMappedDescriptor() {
                return this.desc == null ? null : MappingFile.this.remapDescriptor(this.desc);
            }

            @Override
            @Nullable
            public String write(IMappingFile.Format format, boolean reversed) {
                if (format != IMappingFile.Format.TSRG2 && format.hasFieldTypes() && this.desc == null) {
                    throw new IllegalStateException("Can not write " + format.name() + " format, field is missing descriptor");
                }
                String oOwner = !reversed ? Cls.this.getOriginal() : Cls.this.getMapped();
                String mOwner = !reversed ? Cls.this.getMapped() : Cls.this.getOriginal();
                String oName = !reversed ? this.getOriginal() : this.getMapped();
                String mName = !reversed ? this.getMapped() : this.getOriginal();
                String oDesc = !reversed ? this.getDescriptor() : this.getMappedDescriptor();
                String mDesc = !reversed ? this.getMappedDescriptor() : this.getDescriptor();
                switch (format) {
                    case SRG: {
                        return "FD: " + oOwner + '/' + oName + ' ' + mOwner + '/' + mName + (oDesc == null ? "" : " # " + oDesc + " " + mDesc);
                    }
                    case XSRG: {
                        return "FD: " + oOwner + '/' + oName + (oDesc == null ? "" : ' ' + oDesc) + ' ' + mOwner + '/' + mName + (mDesc == null ? "" : ' ' + mDesc);
                    }
                    case CSRG: {
                        return oOwner + ' ' + oName + ' ' + mName;
                    }
                    case TSRG: {
                        return '\t' + oName + ' ' + mName;
                    }
                    case TSRG2: {
                        return '\t' + oName + (oDesc == null ? "" : ' ' + oDesc) + ' ' + mName;
                    }
                    case PG: {
                        return "    " + InternalUtils.toSource(oDesc) + ' ' + oName + " -> " + mName;
                    }
                    case TINY1: {
                        return "FIELD\t" + oOwner + '\t' + oDesc + '\t' + oName + '\t' + mName;
                    }
                    case TINY: {
                        return "\tf\t" + oDesc + '\t' + oName + '\t' + mName;
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }

            public String toString() {
                return this.write(IMappingFile.Format.SRG, false);
            }

            @Override
            public Cls getParent() {
                return Cls.this;
            }
        }
    }

    class Package
    extends Node
    implements IMappingFile.IPackage {
        protected Package(String original, String mapped, Map<String, String> metadata) {
            super(original, mapped, metadata);
        }

        @Override
        @Nullable
        public String write(IMappingFile.Format format, boolean reversed) {
            String smap;
            String sorig = this.getOriginal().isEmpty() ? "." : this.getOriginal();
            String string = smap = this.getMapped().isEmpty() ? "." : this.getMapped();
            if (reversed) {
                String tmp = sorig;
                sorig = smap;
                smap = tmp;
            }
            switch (format) {
                case SRG: 
                case XSRG: {
                    return "PK: " + sorig + ' ' + smap;
                }
                case TSRG2: 
                case CSRG: 
                case TSRG: {
                    return this.getOriginal() + "/ " + this.getMapped() + '/';
                }
                case TINY1: 
                case PG: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        public String toString() {
            return this.write(IMappingFile.Format.SRG, false);
        }
    }

    abstract class Node
    implements IMappingFile.INode {
        private final String original;
        private final String mapped;
        private final Map<String, String> metadata;

        protected Node(String original, String mapped, Map<String, String> metadata) {
            this.original = original;
            this.mapped = mapped;
            this.metadata = metadata.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
        }

        @Override
        public String getOriginal() {
            return this.original;
        }

        @Override
        public String getMapped() {
            return this.mapped;
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

