/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.relocated.joptsimple;

import net.minecraftforge.fart.relocated.joptsimple.ArgumentList;
import net.minecraftforge.fart.relocated.joptsimple.OptionParser;
import net.minecraftforge.fart.relocated.joptsimple.OptionSet;
import net.minecraftforge.fart.relocated.joptsimple.ParserRules;
import net.minecraftforge.fart.relocated.joptsimple.UnrecognizedOptionException;

abstract class OptionParserState {
    OptionParserState() {
    }

    static OptionParserState noMoreOptions() {
        return new OptionParserState(){

            @Override
            protected void handleArgument(OptionParser parser, ArgumentList arguments, OptionSet detectedOptions) {
                parser.handleNonOptionArgument(arguments.next(), arguments, detectedOptions);
            }
        };
    }

    static OptionParserState moreOptions(final boolean posixlyCorrect) {
        return new OptionParserState(){

            @Override
            protected void handleArgument(OptionParser parser, ArgumentList arguments, OptionSet detectedOptions) {
                String candidate;
                block6: {
                    candidate = arguments.next();
                    try {
                        if (ParserRules.isOptionTerminator(candidate)) {
                            parser.noMoreOptions();
                            return;
                        }
                        if (ParserRules.isLongOptionToken(candidate)) {
                            parser.handleLongOptionToken(candidate, arguments, detectedOptions);
                            return;
                        }
                        if (ParserRules.isShortOptionToken(candidate)) {
                            parser.handleShortOptionToken(candidate, arguments, detectedOptions);
                            return;
                        }
                    }
                    catch (UnrecognizedOptionException e) {
                        if (parser.doesAllowsUnrecognizedOptions()) break block6;
                        throw e;
                    }
                }
                if (posixlyCorrect) {
                    parser.noMoreOptions();
                }
                parser.handleNonOptionArgument(candidate, arguments, detectedOptions);
            }
        };
    }

    protected abstract void handleArgument(OptionParser var1, ArgumentList var2, OptionSet var3);
}

